/*
 * Decompiled with CFR 0.152.
 */
package nihiltres.engineersdoors.common.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundEvent;
import nihiltres.engineersdoors.common.item.IModule;

public abstract class AbstractModule
implements IModule {
    private final String name;
    protected final ArrayList<Block> blocks = new ArrayList();
    protected final ArrayList<Item> items = new ArrayList();
    protected final ArrayList<IRecipe> recipes = new ArrayList();
    protected final ArrayList<SoundEvent> soundEvents = new ArrayList();
    protected final ArrayList<Class<? extends TileEntity>> tileEntities = new ArrayList();

    protected AbstractModule(String nameIn) {
        this.name = nameIn;
    }

    private <T> boolean addT(Collection<T> c, Collection<T> a) {
        return c.addAll(a);
    }

    private <T> boolean addT(Collection<T> c, T[] a) {
        return c.addAll(Arrays.asList(a));
    }

    protected boolean addBlocks(Collection<Block> c) {
        return this.addT(this.blocks, c);
    }

    protected boolean addBlocks(Block ... a) {
        return this.addT(this.blocks, a);
    }

    protected boolean addItems(Collection<Item> c) {
        return this.addT(this.items, c);
    }

    protected boolean addItems(Item ... a) {
        return this.addT(this.items, a);
    }

    protected boolean addRecipes(Collection<IRecipe> c) {
        return this.addT(this.recipes, c);
    }

    protected boolean addRecipes(IRecipe ... a) {
        return this.addT(this.recipes, a);
    }

    protected boolean addSoundEvents(Collection<SoundEvent> c) {
        return this.addT(this.soundEvents, c);
    }

    protected boolean addSoundEvents(SoundEvent ... a) {
        return this.addT(this.soundEvents, a);
    }

    protected boolean addTileEntities(Collection<Class<? extends TileEntity>> c) {
        return this.addT(this.tileEntities, c);
    }

    @SafeVarargs
    protected final boolean addTileEntities(Class<? extends TileEntity> ... a) {
        return this.addT(this.tileEntities, a);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<Block> getBlocks() {
        return this.blocks;
    }

    @Override
    public Collection<Item> getItems() {
        return this.items;
    }

    @Override
    public Collection<IRecipe> getRecipes() {
        return this.recipes;
    }

    @Override
    public Collection<SoundEvent> getSoundEvents() {
        return this.soundEvents;
    }

    @Override
    public Collection<Class<? extends TileEntity>> getTileEntities() {
        return this.tileEntities;
    }
}

